/**
 * Bootstrapper for Solitaire Extension
 * Creates a Shadow DOM host and initializes the game.
 */

(function() {
  // Prevent duplicate injection
  if (document.getElementById('solitaire-extension-host')) return;

  if (!document.body) return;

  const host = document.createElement('div');
  host.id = 'solitaire-extension-host';
  // Force styles to prevent page CSS interference
  host.style.cssText = 'all: initial; display: block; position: fixed; top: 0; left: 0; width: 100%; z-index: 2147483647; pointer-events: none;';
  document.body.appendChild(host);

  const shadow = host.attachShadow({ mode: 'open' });

  if (!window.SolitaireGame || !window.SolitaireCSS) {
    console.error('Solitaire Extension: Failed to load resources.');
    return;
  }

  // Inject Styles
  const style = document.createElement('style');
  style.textContent = window.SolitaireCSS;
  shadow.appendChild(style);

  // Initialize Game
  new window.SolitaireGame(shadow);

  chrome.runtime.onMessage.addListener((request, sender, sendResponse) => {
    if (request.action === 'toggle_solitaire') {
      host.style.display = host.style.display === 'none' ? 'block' : 'none';
    }
  });
})();
